﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace JI_4040_Code_Examples_C_Sharp
{
    public partial class Form1 : Form
    {

      
               
        
        public Form1()
        {
            InitializeComponent();
        }

        


        //-------------------------------------------------------------------------------//
        private void USBopenButton_Click(object sender, EventArgs e)
        {
            CMDExecTextBox.Text = "--";

            if (DemoModeCheckBox.Checked == true)
            {
                statusBox.Text = "Open";
                USBopenButton.Enabled = false;
                enableAllGroupBoxes();
                return;
            }
            else
            {
                if (JI4040_Device.Open() != 0)
                {
                    statusBox.Text = "Error: USB Open";
                }
                else
                {
                    if (JI4040_Device.Init() == true)
                    {
                        if (initJI4040() == true)
                        {
                            statusBox.Text = "Error: initJI4040";
                            return;
                        }
                        statusBox.Text = "Open";
                        USBopenButton.Enabled = false;
                        enableAllGroupBoxes();
                        return;
                    }
                    else
                    {
                        statusBox.Text = "Error: Init";
                        return;
                    }
                    
                }
            }
          
        }
        //-------------------------------------------------------------------------------//

        //-------------------------------------------------------------------------------//
        private void USBcloseButton_Click(object sender, EventArgs e)
        {
            CMDExecTextBox.Text = "--";

            if (DemoModeCheckBox.Checked == true)
            {
                statusBox.Text = "Closed";
                USBopenButton.Enabled = true;
                disableAllGroupBoxes();
                return;
            }
            // Live //
            // Set all ports to input // 
            initJI4040();
            // Close USB //
            int i = JI4040_Device.Close();
            if ( i != 0)
            {
                statusBox.Text = "Error: USB Close";
            }
            else
            {
                statusBox.Text = "Closed";
            }
            USBopenButton.Enabled = true;
            disableAllGroupBoxes();
            allPortsDataXX();
        }
        //-------------------------------------------------------------------------------//



        //-------------------------------------------------------------------------------//
        // Initilize JI-4040 HW
        private bool initJI4040()
        {
            // Set all ports to Input //  
            bool errorFLG = false;
            if (JI4040_Device.Write("DA00") != true)
            {
                errorFLG = true;
            }
            if (JI4040_Device.Write("DB00") != true)
            {
                errorFLG = true;
            }
            if (JI4040_Device.Write("DC00") != true)
            {
                errorFLG = true;
            }
            if (JI4040_Device.Write("DD00") != true)
            {
                errorFLG = true;
            }
            if (JI4040_Device.Write("DE00") != true)
            {
                errorFLG = true;
            }
            if (JI4040_Device.Write("DF00") != true)
            {
                errorFLG = true;
            }

             // Write 00h to all ports //  
            if (JI4040_Device.Write("WA00") != true)
            {
                errorFLG = true;
            }
            if (JI4040_Device.Write("WB00") != true)
            {
                errorFLG = true;
            }
            if (JI4040_Device.Write("WC00") != true)
            {
                errorFLG = true;
            }
            if (JI4040_Device.Write("WD00") != true)
            {
                errorFLG = true;
            }
            if (JI4040_Device.Write("WE00") != true)
            {
                errorFLG = true;
            }
            if (JI4040_Device.Write("WF00") != true)
            {
                errorFLG = true;
            }

            // Stop Ports G & H functions 
            if (JI4040_Device.Write("PG") != true)
            {
                errorFLG = true;
            }
            if (JI4040_Device.Write("PH") != true)
            {
                errorFLG = true;
            }
            // Set Ports G & H as inputs
            if (JI4040_Device.Write("CG00") != true)
            {
                errorFLG = true;
            }
            if (JI4040_Device.Write("CH00") != true)
            {
                errorFLG = true;
            }

            
            return errorFLG;

        }
        //-------------------------------------------------------------------------------//

        //-------------------------------------------------------------------------------//
        // Enable All Group Boxes
        private void enableAllGroupBoxes()
        {
            USBcloseButton.Enabled = true;
            setPortDirection_GroupBox.Enabled = true;
            gPP_ReadWrite_GroupBox.Enabled = true;
                        
            
            // PortG Config enable boxes within group // 
            portGConfig_GroupBox.Enabled = true;
            portG_CLK_PreScalarGroupBox.Enabled = true;
            portG_GeneratorGroupBox.Enabled = true;
            portG_CLK_TimerGroupBox.Enabled = true;
            portG_CounterGroupBox.Enabled = true;

            // PortH  Config enable boxes within group // 
            portHConfig_GroupBox.Enabled = true;
            portH_CLK_PreScalarGroupBox.Enabled = true;
            portH_GeneratorGroupBox.Enabled = true;
            portH_CLK_TimerGroupBox.Enabled = true;
            portH_CounterGroupBox.Enabled = true;

        }
        //-------------------------------------------------------------------------------//

        //-------------------------------------------------------------------------------//
        // Disable All Group Boxes
        private void disableAllGroupBoxes()
        {
            USBcloseButton.Enabled = false;
            setPortDirection_GroupBox.Enabled = false;
            gPP_ReadWrite_GroupBox.Enabled = false;
            portGConfig_GroupBox.Enabled = false;

            portHConfig_GroupBox.Enabled = false;

            allPortsDisplayInput();
            clearAllReadWriteData();
                   

            portGInit();
            portHInit();

        }
        //-------------------------------------------------------------------------------//


        //-------------------------------------------------------------------------------//
        private void Form1_Load(object sender, EventArgs e)
        {
            hide_Display_Ctrl_Pictures();
            portGInit();
            portHInit();

        }
        //-------------------------------------------------------------------------------//

        //-------------------------------------------------------------------------------//
        private void allPortsDataXX()
        {
            portAData.Text = "XX";
            portBData.Text = "XX";
            portCData.Text = "XX";
            portDData.Text = "XX";
            portEData.Text = "XX";
            portFData.Text = "XX";
        }
        //-------------------------------------------------------------------------------//

        //-------------------------------------------------------------------------------//
       
        //-------------------------------------------------------------------------------//



        uint dataByteInt = 0;

        //-------------------------------------------------------------------------------//
        
        //-------------------------------------------------------------------------------//

        // Create and initialize 
        // instance of enum type
        portFunctionType portG_Function = portFunctionType.NOP;
        portFunctionType portH_Function = portFunctionType.NOP;
        //-------------------------------------------------------------------------------//
        //
        enum portFunctionType
        {
            NOP, // No operation

            CLK_Generator,
            Pulse_Generator,
            
            Period_Timer_Rising,
            Period_Timer_Falling,
            Pulse_Timer_Rising_Falling,
            Pulse_Timer_Falling_Rising,

            EventCounter_Rising,
            EventCounter_Falling,
        }
        //-------------------------------------------------------------------------------//


        //-------------------------------------------------------------------------------//
        private void hide_Display_Ctrl_Pictures()
        {
            CW_Pos_Pic.Visible = false;
            CW_Neg_Pic.Visible = false;
            Pulse_Pos_Pic.Visible = false;
            Pulse_Neg_Pic.Visible = false;
            Pulse_Timer_FallRise_Pic.Visible = false;
            Pulse_Timer_RiseFall_Pic.Visible = false;
            Period_Timer_Rise_Pic.Visible = false;
            Period_Timer_Fall_Pic.Visible = false;
            EventCount_Rise_Pic.Visible = false;
            EventCount_Fall_Pic.Visible = false;

            // Set ports G and H to NOP status
            portG_Function = portFunctionType.NOP;
            portG_Display_Ctrl(portG_Function);
        }


        //-------------------------------------------------------------------------------//
        //
        // Tool Strip Menu Items
        //
        private void toolStripMenuItem1_Click(object sender, EventArgs e)
        {
            About messsagePopUp = new About();
            messsagePopUp.ShowDialog();
        }
        //-------------------------------------------------------------------------------//

    

   //     private void portG_CounterRisingEdge_SelectButton_Click(object sender, EventArgs e)
   //     {

   //     }

   

//        private void portH_PulseGen_Timer_Tick(object sender, EventArgs e)
//        {
//
//        }

     //   private void portG_PulseGen_Timer_Tick(object sender, EventArgs e)
     //   {

    //    }

      
      //---------------//





       
    }
}
